<?php
$topsguarantor_2 = array();
		$topsguarantor_2["selectList"] = array(
		"subtype" => "sql",
		"sql" => "SELECT
    t.loan_id,
    t.customer_id,
    t.horno,
    t.guarantor_1,
    t.guarantor_2,

    t.full_name,
    t.nic,
    t.phone,
    t.address,

    t.loan_amount,
    t.total_payable,
    t.installment_amount,
    t.payment_interval_days,
    t.start_date,
    t.end_date,
    t.status,
    t.profit_amount,
    t.total_collected,

    (FLOOR(DATEDIFF(CURDATE(), t.start_date) / t.payment_interval_days) + 1)
        * t.installment_amount AS should_pay,

    (t.total_payable - t.total_collected) AS remaining_balance,

    GREATEST(
        (
            (FLOOR(DATEDIFF(CURDATE(), t.start_date) / t.payment_interval_days) + 1)
            * t.installment_amount
        ) - t.total_collected,
        0
    ) AS arrears_amount,    /* Days left until end */
    DATEDIFF(t.end_date, CURDATE()) AS remaining_days,

    /* Remaining installments */
    GREATEST(
        ROUND((t.total_payable / t.installment_amount) 
              - (t.total_collected / t.installment_amount), 0),
        0
    ) AS remaining_installments

FROM (
    SELECT
        l.loan_id,
        l.customer_id,
        l.horno,
        l.guarantor_1,
        l.guarantor_2,

        cus.full_name,
        cus.nic,
        cus.phone,
        cus.address,

        l.loan_amount,
        l.total_payable,
        l.installment_amount,
        l.payment_interval_days,
        l.start_date,
        l.end_date,
        l.status,
        l.profit_amount,

        IFNULL(SUM(c.amount), 0) AS total_collected

    FROM loans l
    LEFT JOIN customers cus ON l.customer_id = cus.customer_id
    LEFT JOIN collections c ON l.loan_id = c.loan_id
    WHERE 1
    GROUP BY l.loan_id
) AS t

ORDER BY t.loan_id DESC;
"
	);
		$tables_data["Guarantor 2"][".operations"] = &$topsguarantor_2;
?>